/**
 * donutty // Create SVG donut charts with Javascript
 * @author simeydotme <simey.me@gmail.com>
 * @version 2.0.0
 * @license MIT
 * @link http://simey.me
 * @preserve
 */
 !function(t,i){var s,e="http://www.w3.org/2000/svg";function o(t){return void 0!==t}function n(t){return parseFloat(t,10)}function r(t){return o(t)&&(!0===t||"true"===t)}(s=i.Donutty=function(i,s){return i&&"string"==typeof i?this.$wrapper=t.querySelectorAll(i)[0]:t.querySelector(`.${i.className}`)?this.$wrapper=i:(this.$wrapper=t.body,s=i),this.$wrapper?(o(s)||(s=this.getOptionsFromTag()),this.state={},this.options=s||{},this.options.min=o(this.options.min)?n(this.options.min):0,this.options.max=o(this.options.max)?n(this.options.max):100,this.options.value=o(this.options.value)?n(this.options.value):50,this.options.round=!o(this.options.round)||r(this.options.round),this.options.circle=!o(this.options.circle)||r(this.options.circle),this.options.padding=o(this.options.padding)?n(this.options.padding):4,this.options.radius=n(this.options.radius)||50,this.options.thickness=n(this.options.thickness)||10,this.options.bg=this.options.bg||"rgba(70, 130, 180, 0.15)",this.options.color=this.options.color||"mediumslateblue",this.options.transition=this.options.transition||"all 1.2s cubic-bezier(0.57, 0.13, 0.18, 0.98)",this.options.text=!!o(this.options.text)&&this.options.text,this.init(),this):this}).prototype.getOptionsFromTag=function(){return JSON.parse(JSON.stringify(this.$wrapper.dataset))},s.prototype.init=function(){var t;return this.$wrapper.donutty=this,this.createState(),t=this.getDashValues(),this.createSvg(),this.createBg(t),this.createDonut(t),this.createText(),this.insertFragments(t),this},s.prototype.createState=function(){return this.state.min=this.options.min,this.state.max=this.options.max,this.state.value=this.options.value,this.state.bg=this.options.bg,this.state.color=this.options.color,this},s.prototype.createText=function(){return"function"==typeof this.options.text&&(this.$text=t.createElement("span"),this.$text.setAttribute("class","donut-text"),this.$text.style.opacity=0,this.updateText()),this},s.prototype.createBg=function(i){return this.$bg=t.createElementNS(e,"circle"),this.$bg.setAttribute("cx","50%"),this.$bg.setAttribute("cy","50%"),this.$bg.setAttribute("r",this.options.radius),this.$bg.setAttribute("fill","transparent"),this.$bg.setAttribute("stroke",this.state.bg),this.$bg.setAttribute("stroke-width",this.options.thickness+this.options.padding),this.$bg.setAttribute("stroke-dasharray",i.full*i.multiplier),this.$bg.setAttribute("class","donut-bg"),this.options.round&&this.$bg.setAttribute("stroke-linecap","round"),this},s.prototype.createDonut=function(i){return this.$donut=t.createElementNS(e,"circle"),this.$donut.setAttribute("fill","transparent"),this.$donut.setAttribute("cx","50%"),this.$donut.setAttribute("cy","50%"),this.$donut.setAttribute("r",this.options.radius),this.$donut.setAttribute("stroke",this.state.color),this.$donut.setAttribute("stroke-width",this.options.thickness),this.$donut.setAttribute("stroke-dashoffset",i.full),this.$donut.setAttribute("stroke-dasharray",i.full),this.$donut.setAttribute("class","donut-fill"),this.$donut.style.opacity=0,this.options.round&&this.$donut.setAttribute("stroke-linecap","round"),this},s.prototype.createSvg=function(){var i=2*this.options.radius+this.options.thickness+2*this.options.padding,s=this.options.round?this.options.thickness/3:0,o=this.options.circle?90+s:-225;return this.$html=t.createDocumentFragment(),this.$svg=t.createElementNS(e,"svg"),this.$svg.setAttribute("xmlns",e),this.$svg.setAttribute("viewbox","0 0 "+i+" "+i),this.$svg.setAttribute("transform","rotate( "+o+" )"),this.$svg.setAttribute("preserveAspectRatio","xMidYMid meet"),this.$svg.setAttribute("class","donut"),this},s.prototype.insertFragments=function(t){this.$svg.appendChild(this.$bg),this.$svg.appendChild(this.$donut),this.$html.appendChild(this.$svg),this.$text&&this.$html.appendChild(this.$text),this.$wrapper.appendChild(this.$html),this.$wrapper.innerHTML=this.$wrapper.innerHTML,this.$svg=this.$wrapper.querySelector(".donut"),this.$bg=this.$wrapper.querySelector(".donut-bg"),this.$donut=this.$wrapper.querySelector(".donut-fill"),this.$text&&(this.$text=this.$wrapper.querySelector(".donut-text")),this.animate(t.fill,t.full)},s.prototype.getDashValues=function(){var t,i,s,e;return e=this.options.circle?1:.75,s=(t=2*Math.PI*this.options.radius)-t*e/100*(i=(this.state.value-this.state.min)/(this.state.max-this.state.min)*100),this.options.round&&this.options.circle&&i<100&&s<this.options.thickness&&(s=this.options.thickness),{fill:s,full:t,multiplier:e}},s.prototype.animate=function(t,i){var s=this;s.$bg.style.transition=this.options.transition,s.$donut.style.transition=this.options.transition,s.$text&&(s.$text.style.transition=this.options.transition),window.setTimeout(function(){s.$bg.setAttribute("stroke",s.state.bg),s.$bg.style.opacity=1,s.$donut.setAttribute("stroke-dashoffset",t),s.$donut.setAttribute("stroke-dasharray",i),s.$donut.setAttribute("stroke",s.state.color),s.$donut.style.opacity=1,s.$text&&(s.$text.style.opacity=1)},16)},s.prototype.updateText=function(){return"function"==typeof this.options.text&&(this.$text.innerHTML=this.options.text(this.state)),this},s.prototype.set=function(t,i){var s;return o(t)&&o(i)&&(this.state[t]=i,s=this.getDashValues(),this.updateText(),this.animate(s.fill,s.full)),this},s.prototype.setState=function(t){var i;return o(t.value)&&(this.state.value=t.value),o(t.min)&&(this.state.min=t.min),o(t.max)&&(this.state.max=t.max),o(t.bg)&&(this.state.bg=t.bg),o(t.color)&&(this.state.color=t.color),i=this.getDashValues(),this.updateText(),this.animate(i.fill,i.full),this}}(document,window),function(t,i){void 0!==$?i(function(){i.fn.donutty=function(s){return i(this).each(function(){new t(this,s)})},i("[data-donutty]").donutty()}):console.warn("Can't find jQuery to attach Donutty")}(Donutty,jQuery);